// Rasterbation shader by daxnitro.

uniform sampler2D sampler0;

uniform float aspectRatio;

vec4 getBoxColor(vec2 coord, vec2 boxSize, vec2 sampleInterval);

void main() {
	vec2 boxSize = vec2(0.004, 0.004 * aspectRatio);
	
    vec4 color = getBoxColor(gl_TexCoord[0].st, boxSize, vec2(0.001, 0.001 * aspectRatio));
    
    float radius = 1.0 - (color.r + color.g + color.b) / 3.0;

    float radiusSquared = radius * radius;
        
    vec2 boxPoint = 2.0 * mod(gl_TexCoord[0].st, boxSize) / boxSize - 1.0;
    
    vec2 boxPointSquared = boxPoint * boxPoint;
    
    if (boxPointSquared.y <= radiusSquared - boxPointSquared.x && boxPointSquared.x <= radiusSquared - boxPointSquared.y) {
    	gl_FragColor = vec4(0.0, 0.0, 0.0, 1.0);
    } else {
    	gl_FragColor = vec4(1.0, 1.0, 1.0, 1.0);
    }
}

vec4 getBoxColor(vec2 coord, vec2 boxSize, vec2 sampleInterval) {
	vec2 limit = min(coord + boxSize, 1.0);
	
	coord -= mod(coord, boxSize);
	
	vec4 color = vec4(0.0);
	
	float samples = 0.0;
	
	do {
		color += texture2D(sampler0, coord);
		++samples;
		coord += sampleInterval;
	} while (coord.x < limit.x && coord.y < limit.y);
	
	color /= samples;
	
	return color;
}
